// Run module
#include "app.h"
#include "xbinput.h"

static unsigned int nNormalLast=0; // Last value of timeGetTime()
static int nNormalFrac=0; // Extra fraction we did
int bRunPause=0;
static int bAppStep=0,bAppFastForward=0;
static int bAppDoFast=0;
static int nFastSpeed=6;
int bReadInputEveryFrame=1;
extern XBGAMEPAD g_Gamepads[4];
bool RequestExit = false;
extern unsigned char *DtosMem;
extern float zLeft;
extern float zRight;
extern float zTop;
extern float zBottom;
extern void ReadInput();
extern int MakeVertexList();
extern int SetupMatrices();
extern "C" int dprintf(char *format, ...);
extern DSoundStop();
extern void SaveIni();
extern void SaveScreen();
extern void EmulationMenu();


void CheckInput() {
	if (g_Gamepads[0].wButtons & XINPUT_GAMEPAD_RIGHT_THUMB) {
		DSoundStop();
		EmulationMenu();
	}
	/*if ((g_Gamepads[0].wButtons & XINPUT_GAMEPAD_BACK) && (g_Gamepads[0].wButtons & XINPUT_GAMEPAD_START)) {
		SaveIni();
		RequestExit = true;
		return;
	}*/
		
	//if(g_Gamepads[0].Event == XBGAMEPAD_X) {
	//	SaveScreen();
	//}

	//bool screenChange = false;
	//if (g_Gamepads[0].fY1 > 0) { screenChange = true; zTop+=0.1f;  zBottom+=0.1f; }// Up
	//if (g_Gamepads[0].fY1 < 0) { screenChange = true; zTop-=0.1f;  zBottom-=0.1f; } // Down
	//if (g_Gamepads[0].fX1 < 0) { screenChange = true; zLeft-=0.1f; zRight-=0.1f; } // Left
	//if (g_Gamepads[0].fX1 > 0) { screenChange = true; zLeft+=0.1f; zRight+=0.1f; }// Right
	//if (g_Gamepads[0].fY2 > 0) { screenChange = true; zBottom+=0.1f; } // Up
	//if (g_Gamepads[0].fY2 < 0) { screenChange = true; zBottom-=0.1f; } // Down
	//if (g_Gamepads[0].fX2 < 0) { screenChange = true; zRight-=0.1f; } // Left
	//if (g_Gamepads[0].fX2 > 0) { screenChange = true; zRight+=0.1f; } // Right

	//if(screenChange) {
	//	//SaveIni();
	//	MakeVertexList();
	//}
}

static int GetInput()
{
	ReadInput();
	CheckInput();
	if(RequestExit == true) return 0;
	InputMake(); // get input
	return 0;
}

// With or without sound, run one frame.
// If bDraw is true, it's the last frame before we are up to date, and so we should draw the screen
static int RunFrame(int bDraw,int bPause)
{
	static int bOldStretch=0;
	bOldStretch=bDtoStretch;

	// Get input (even if paused - so it'll show on the dialog)
	if (bReadInputEveryFrame)
	{
		GetInput(); // Get input on all frames
		if(RequestExit == true) return 0;
	}
	else
	{
		if (bDraw) GetInput(); // Get input on draw frames only
	}

	InputTick(); // Tick one frame of input (for sliders etc)

	if (!bPause)
	{
		if (bDraw)
		{
			VidFrame();  // Do one frame
		}
		else
		{    
			// frame skipping
			pBurnDraw=NULL; // Make sure no image is drawn
			if (bDrvOkay)
			{
				BurnDrvFrame();
			}
		}
	}
	return 0;
}

// Callback used when DSound needs more sound
static int RunGetNextSound(int bDraw)
{
	dprintf("RunGetNextSound\n");
	if (DSoundNextSound==NULL) return 1;

	if (bRunPause && bAppStep==0)
	{
		memset(DSoundNextSound,0,nDSoundSegLen<<2); // Write silence into the buffer
		RunFrame(bDraw,1);
		return 0;
	}

	if (bAppDoFast)
	{ int i; for (i=0;i<nFastSpeed;i++) RunFrame(0,0); } // do more frames

	// Render frame with sound
	pBurnSoundOut=NULL;
	if (!bAppStep) pBurnSoundOut=DSoundNextSound;
	RunFrame(bDraw,0);
	pBurnSoundOut=NULL;

	bAppStep=0; // done one step

	return 0;
}

int RunReset()
{
	// reset the speed throttling code
	nNormalLast=0; nNormalFrac=0;
	if (!bDSoundPlaying)
	{
		dprintf("!bDSoundPlaying\n");
		// run without sound
		nNormalLast=timeGetTime();
	}
	return 0;
}

static int RunInit()
{
	// Try to run with sound
	DSoundGetNextSound=RunGetNextSound;
	DSoundPlay();

	RunReset();
	// Get the first input before we start, because we only
	// get input afterwards on draw frames.
	GetInput();
	return 0;
}

static int RunExit()
{
	nNormalLast=0;
	// Stop sound if it was playing
	DSoundStop();
	return 0;
}

// The main message loop
int RunMessageLoop()
{
	int bRestartVideo=0;
	RunInit();
	bRestartVideo=0;
	SetupMatrices();
	for (;;)
	{
		if(RequestExit) {
			DSoundStop();
			RequestExit = false;
			free(DtosMem);
			DrvExit();
			return 0;
		}
		if(bDSoundPlaying) {
			//dprintf("DSoundCheck\n");
			DSoundCheck();
		}
		else {
			dprintf("No Sound\n");
		}
	}
	return 0;
}
